package moreoop;

import java.util.Scanner;

public class Main {

    public static void main(String[] args) {
        // where we will test our classes

        // code for testing Room class:
        Room here = new Room();  // default room

        // room with specific name and dimensions
        Room there = new Room("b301", 12, 8);

        // room with specific name and default dimensions
        Room office = new Room("E200");

        // manually assign length and width
        office.width = 8;
        office.length = 15;

        // display the various rooms
        System.out.println(here.displayRoom());
        System.out.println(there.displayRoom());
        System.out.println(office.displayRoom());

        // try the area/perimeter methods
        System.out.printf("Office:\nArea: %.1f\nPerimeter: %.1f\n",
                office.calculateArea(), office.calculatePerimeter());

        // try the maxSitting()/maxStanding()  methods
        System.out.printf("E200 Max Capacity:\nSitting: %d\n"
                + "Standing: %d\n", office.maxSitting(), office.maxStanding());

   
    }


    // this is used for a demonstration dealing with empty/null strings
    public static String getString() {
        // make a quick scanner
		Scanner in = new Scanner(System.in);
        // grab a string for the name
		System.out.print("Enter name: ");
		String str = in.nextLine();
        in.close();  // close scanner

        // FYI: isBlank() returns true if the string is empty or contains 
        // only whitespace characters

        // if the user typed whitespace only, or typed nothing and pressed ENTER
		if (str.isBlank()) {
			return null;  // FYI null = no object, no reference, no memory address
		
        } else {  // user typed something with non-whitespace characters
			return str; 
		}		
	}
}
